//==========================================================================
// File Name   : ComAir5_RX_RX_USER.asm
// Description : Users implement functions
// Written by  : Porter Yang
// Last modified date:
//              2010/08/30
// Note: 
//==========================================================================
//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPCE2P064.inc
		
//**************************************************************************
// Contant Defintion Area
//**************************************************************************
.define C_ComAir5_RX_Timer_Setting		C_Timer_Setting_48K			

.define Mic_In		
//.define Line_In		// input form IOB0

//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public F_ComAir5_RX_HW_Init	
.public F_ComAir5_RX_HW_Stop
.public F_ComAir5_RX_HW_GetADC

//**************************************************************************
// RAM Definition Area
//**************************************************************************

//*****************************************************************************
// Table Definition Area
//*****************************************************************************

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE
//****************************************************************
// Function    : F_ComAir5_RX_HW_Init
// Description : ComAir5 RX hardware initial, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_RX_HW_Init: .proc
	push BP to [SP];
	FIQ off
	FIR_MOV off;
	
	R1 = [P_Timer_Ctrl];
	R1 |= C_TimerA_FPLL;			// TimerA CKA=Fosc/2 CKB=1 Tout:off
	[P_Timer_Ctrl] = R1;
	R1= C_ComAir5_RX_Timer_Setting;	// TimerA setting
	[P_TimerA_Data] = R1;
	[P_TimerA_CNTR] = R1;

	R1 = 0
	[P_DAC_Ctrl] = R1;
	[P_PPAMP_Ctrl] = R1;

.ifdef Mic_In
	R1 = C_ADC_Enable | C_AGC_Enable | C_ADC_CLK_FPLL_Div_32 | C_ADC_Bias_Enable | C_ADC_MIC_Enable | C_ADC_Timer_A
	[P_ADC_Ctrl] = R1;
	R1 = C_ADC_PGA_Disable;
	[P_ADC_PGA_Ctrl] = R1;
.else
	R1 = C_ADC_Enable | C_ADC_CLK_FPLL_Div_32 | C_ADC_Timer_A
	R1 |= C_ADC_Bias_Enable | C_ADC_MIC_Disable | C_ADC_Ch0_in_LineinPB0 | C_ADC_Manual_AN0
	[P_ADC_Ctrl] = R1;
	R1 = 0x0001
	[P_ADC_LineIn_BitCtrl] = R1
.endif	

	R1 = [P_INT_Ctrl];
	R1 |= C_IRQ0_TMA
	[P_INT_Ctrl] = R1;

	R1 = [P_FIQ_Sel];
	R1 |= C_IRQ0_TMA;
	[P_FIQ_Sel] = R1;

	FIQ on;
    pop BP from [SP];
	retf
	.endp
	
//****************************************************************
// Function    : F_ComAir5_RX_HW_Stop
// Description : Hardware End for ComAir5 RX, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_RX_HW_Stop: .proc
	push BP to [SP];

	R1 = [P_INT_Ctrl];
	R1 &= ~C_IRQ0_TMA
	[P_INT_Ctrl] = R1;
	R1 = 0
	[P_FIQ_Sel] = R1;

    pop BP from [SP];
	retf
	.endp		

//****************************************************************
// Function    : F_ComAir5_RX_HW_GetADC
// Description : Get ADC data for ComAir5 RX, called by library
// Destory     : R1
// Parameter   : None
// Return      : R3 = signed ADC data
// Note        : None
//****************************************************************
F_ComAir5_RX_HW_GetADC:	.proc
	R3 = [P_ADC_Data];			// unsigned
	R3 ^= 0x8000;				// unsigned to signed
	retf;
	.endp
